package com.ejie.p06b.datatype.model;

import java.io.Serializable;
import java.util.Date;

import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.util.P06BParametros;

/**
 * Fecha de creacin: (07/07/2017)
 */
public class P06B64T00Datatype implements Serializable {
	
	private static final long serialVersionUID = 1L;
	private int correlativo = -1;
	private Date fecha;
	private String mensaje;
	private String contextSubmissionEvent;
	private String ejgvDocument;
	private String idSolicitudTramitagune;
	private boolean finalizada;
	private String mensajeError;
	private String registryNumber;;
	private boolean bActualizarDomicilioSocial;
	private boolean bActualizarCapitalSocial;
	private boolean bActualizarAdministradores;
	private boolean bActualizarOrganoDireccion;
	private boolean bActualizarAtencionDefensaCliente;
	private boolean bActualizarCapacidadFinanciera;
	private boolean bActualizarEntidadesVinculadas;
	private byte estado = P06BConstantes.P06B_AP_ESTADO_ENSISTEMA;
	private String procedimiento = "";
	private String expediente;

	/**
	 * @return the correlativo
	 */
	public int getCorrelativo() {
		return correlativo;
	}
	/**
	 * @param correlativo the correlativo to set
	 */
	public void setCorrelativo(int correlativo) {
		this.correlativo = correlativo;
	}
	/**
	 * @return the fecha
	 */
	public Date getFecha() {
		return fecha;
	}
	/**
	 * @param fecha the fecha to set
	 */
	public void setFecha(Date fecha) {
		this.fecha = fecha;
	}
	/**
	 * @return the mensaje
	 */
	public String getMensaje() {
		return mensaje;
	}
	/**
	 * @param mensaje the mensaje to set
	 */
	public void setMensaje(String mensaje) {
		this.mensaje = mensaje;
	}
	/**
	 * @return the idSolicitudTramitagune
	 */
	public String getIdSolicitudTramitagune() {
		return idSolicitudTramitagune;
	}
	/**
	 * @param idSolicitudTramitagune the idSolicitudTramitagune to set
	 */
	public void setIdSolicitudTramitagune(String idSolicitudTramitagune) {
		this.idSolicitudTramitagune = idSolicitudTramitagune;
	}
	/**
	 * @return the finalizada
	 */
	public boolean isFinalizada() {
		return finalizada;
	}
	/**
	 * @param finalizada the finalizada to set
	 */
	public void setFinalizada(boolean finalizada) {
		this.finalizada = finalizada;
	}
	/**
	 * @return the mensajeError
	 */
	public String getMensajeError() {
		return mensajeError;
	}
	/**
	 * @param mensajeError the mensajeError to set
	 */
	public void setMensajeError(String mensajeError) {
		this.mensajeError = mensajeError;
	}
	/**
	 * @return the registryNumber
	 */
	public String getRegistryNumber() {
		return registryNumber;
	}
	/**
	 * @param registryNumber the registryNumber to set
	 */
	public void setRegistryNumber(String registryNumber) {
		this.registryNumber = registryNumber;
	}
	/**
	 * @return the bActualizarDomicilioSocial
	 */
	public boolean isbActualizarDomicilioSocial() {
		return bActualizarDomicilioSocial;
	}
	/**
	 * @param bActualizarDomicilioSocial the bActualizarDomicilioSocial to set
	 */
	public void setbActualizarDomicilioSocial(boolean bActualizarDomicilioSocial) {
		this.bActualizarDomicilioSocial = bActualizarDomicilioSocial;
	}
	/**
	 * @return the bActualizarCapitalSocial
	 */
	public boolean isbActualizarCapitalSocial() {
		return bActualizarCapitalSocial;
	}
	/**
	 * @param bActualizarCapitalSocial the bActualizarCapitalSocial to set
	 */
	public void setbActualizarCapitalSocial(boolean bActualizarCapitalSocial) {
		this.bActualizarCapitalSocial = bActualizarCapitalSocial;
	}
	/**
	 * @return the bActualizarAdministradores
	 */
	public boolean isbActualizarAdministradores() {
		return bActualizarAdministradores;
	}
	/**
	 * @param bActualizarAdministradores the bActualizarAdministradores to set
	 */
	public void setbActualizarAdministradores(boolean bActualizarAdministradores) {
		this.bActualizarAdministradores = bActualizarAdministradores;
	}
	/**
	 * @return the bActualizarOrganoDireccion
	 */
	public boolean isbActualizarOrganoDireccion() {
		return bActualizarOrganoDireccion;
	}
	/**
	 * @param bActualizarOrganoDireccion the bActualizarOrganoDireccion to set
	 */
	public void setbActualizarOrganoDireccion(boolean bActualizarOrganoDireccion) {
		this.bActualizarOrganoDireccion = bActualizarOrganoDireccion;
	}
	/**
	 * @return the bActualizarAtencionDefensaCliente
	 */
	public boolean isbActualizarAtencionDefensaCliente() {
		return bActualizarAtencionDefensaCliente;
	}
	/**
	 * @param bActualizarAtencionDefensaCliente the bActualizarAtencionDefensaCliente to set
	 */
	public void setbActualizarAtencionDefensaCliente(
			boolean bActualizarAtencionDefensaCliente) {
		this.bActualizarAtencionDefensaCliente = bActualizarAtencionDefensaCliente;
	}
	/**
	 * @return the bActualizarCapacidadFinanciera
	 */
	public boolean isbActualizarCapacidadFinanciera() {
		return bActualizarCapacidadFinanciera;
	}
	/**
	 * @param bActualizarCapacidadFinanciera the bActualizarCapacidadFinanciera to set
	 */
	public void setbActualizarCapacidadFinanciera(
			boolean bActualizarCapacidadFinanciera) {
		this.bActualizarCapacidadFinanciera = bActualizarCapacidadFinanciera;
	}
	/**
	 * @return the bActualizarEntidadesVinculadas
	 */
	public boolean isbActualizarEntidadesVinculadas() {
		return bActualizarEntidadesVinculadas;
	}
	/**
	 * @param bActualizarEntidadesVinculadas the bActualizarEntidadesVinculadas to set
	 */
	public void setbActualizarEntidadesVinculadas(
			boolean bActualizarEntidadesVinculadas) {
		this.bActualizarEntidadesVinculadas = bActualizarEntidadesVinculadas;
	}	
	/**
	 * @return the estado
	 */
	public byte getEstado() {
		return estado;
	}
	/**
	 * @param estado the estado to set
	 */
	public void setEstado(byte estado) {
		this.estado = estado;
	}
	/**
	 * @return the procedimiento
	 */
	public String getProcedimiento() {
		return procedimiento;
	}
	/**
	 * @param procedimiento the procedimiento to set
	 */
	public void setProcedimiento(String procedimiento) {
		this.procedimiento = procedimiento;
	}
	/**
	 * @return the expediente
	 */
	public String getExpediente() {
		return expediente;
	}
	
	/**
	 * @return the contextSubmissionEvent
	 */
	public String getContextSubmissionEvent() {
		return contextSubmissionEvent;
	}
	/**
	 * @param contextSubmissionEvent the contextSubmissionEvent to set
	 */
	public void setContextSubmissionEvent(String contextSubmissionEvent) {
		this.contextSubmissionEvent = contextSubmissionEvent;
	}
	/**
	 * @return the ejgvDocument
	 */
	public String getEjgvDocument() {
		return ejgvDocument;
	}
	/**
	 * @param ejgvDocument the ejgvDocument to set
	 */
	public void setEjgvDocument(String ejgvDocument) {
		this.ejgvDocument = ejgvDocument;
	}
	/**
	 * @param expediente the expediente to set
	 */
	public void setExpediente(String expediente) {
		this.expediente = expediente;
	}
	
	public String getProcedimientoVisible() {
		if (P06BParametros.get("idProcAltaRegMedSeg").equals(procedimiento)){
			return "pantallas.literal.atencionPeticiones.procedimiento.alta";
		}else if (P06BParametros.get("idProcModRegMedSeg").equals(procedimiento)){
			return "pantallas.literal.atencionPeticiones.procedimiento.modificacion";
		}else if (P06BParametros.get("idProcCancelRegMedSeg").equals(procedimiento)){
			return "pantallas.literal.atencionPeticiones.procedimiento.cancelacion";
		}else if (P06BParametros.get("idProcAutorizTransRegMedSeg").equals(procedimiento)){
			return "pantallas.literal.atencionPeticiones.procedimiento.autorizacion";
		}else{
			return null;
		}
	}

	/**
	 * @return the finalizada
	 */
	public String getFinalizadaVisible() {
		if (finalizada){
			return "pantallas.literal.atencionPeticiones.finalizada.correcta";
		}else{
			return "pantallas.literal.atencionPeticiones.finalizada.incorrecta";
		}
	}
	
	/**
	 * @return the estado
	 */
	public String getEstadoVisible() {
	  	if (P06BConstantes.P06B_AP_ESTADO_ENSISTEMA == estado){
			return "pantallas.literal.atencionPeticiones.estado.recogida";
	  	}else if (P06BConstantes.P06B_AP_ESTADO_PORREVISAR == estado){
			return "pantallas.literal.atencionPeticiones.estado.porRevisar";
	  	}else if (P06BConstantes.P06B_AP_ESTADO_APROBADA == estado){
			return "pantallas.literal.atencionPeticiones.estado.aprobada";
	  	}else if (P06BConstantes.P06B_AP_ESTADO_RECHAZADA == estado){
			return "pantallas.literal.atencionPeticiones.estado.rechazada";
	  	}else if (P06BConstantes.P06B_AP_ESTADO_PORCORREGIR == estado){
			return "pantallas.literal.atencionPeticiones.estado.porCorregir";
	  	}else if (P06BConstantes.P06B_AP_ESTADO_CORREGIDA == estado){
			return "pantallas.literal.atencionPeticiones.estado.corregida";
		}else{
			return null;
		}
	}

}
